<?php
class UserLocationPrivilege {
    // Database connection
    private $conn;
    private $table = "user_location_privilege";

    // Properties
    public $user_location_privilege_id;
    public $user_id;
    public $location_id;
    public $privilege;
    public $can_comment;
    public $num_img;
    public $img_size;
    public $num_char_obs;
    public $num_char_ta;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all users
    public function read() {
        $query = "SELECT
            user_location_privilege_id,
            user_id,
            location_id,
            privilege,
            can_comment,
            num_img,
            img_size,
            num_char_obs,
            num_char_ta
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get user by id
    public function read_single() {
        $query = "SELECT
            user_location_privilege_id,
            user_id,
            location_id,
            privilege,
            can_comment,
            num_img,
            img_size,
            num_char_obs,
            num_char_ta
        FROM 
            " . $this->table . "
        WHERE
            user_location_privilege_id = :user_location_privilege_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_location_privilege_id", $this->user_location_privilege_id);
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->user_id = $row["user_id"]; 
        $this->location_id = $row["location_id"]; 
        $this->privilege = $row["privilege"]; 
        $this->can_comment = $row["can_comment"]; 
        $this->num_img = $row["num_img"]; 
        $this->img_size = $row["img_size"]; 
        $this->num_char_obs = $row["num_char_obs"]; 
        $this->num_char_ta = $row["num_char_ta"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            user_id = :user_id,
            location_id = :location_id,
            privilege = :privilege,
            can_comment = :can_comment,
            num_img = :num_img,
            img_size = :img_size,
            num_char_obs = :num_char_obs,
            num_char_ta = :num_char_ta
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->privilege = htmlspecialchars(strip_tags($this->privilege));
        $this->can_comment = htmlspecialchars(strip_tags($this->can_comment));
        $this->num_img = htmlspecialchars(strip_tags($this->num_img));
        $this->img_size = htmlspecialchars(strip_tags($this->img_size));
        $this->num_char_obs = htmlspecialchars(strip_tags($this->num_char_obs));
        $this->num_char_ta = htmlspecialchars(strip_tags($this->num_char_ta));

        // Bind data
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":privilege", $this->privilege);
        $stmt->bindParam(":can_comment", $this->can_comment);
        $stmt->bindParam(":num_img", $this->num_img);
        $stmt->bindParam(":img_size", $this->img_size);
        $stmt->bindParam(":num_char_obs", $this->num_char_obs);
        $stmt->bindParam(":num_char_ta", $this->num_char_ta);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            user_id = :user_id,
            location_id = :location_id,
            privilege = :privilege,
            can_comment = :can_comment,
            num_img = :num_img,
            img_size = :img_size,
            num_char_obs = :num_char_obs,
            num_char_ta = :num_char_ta
        WHERE
            user_location_privilege_id = :user_location_privilege_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->privilege = htmlspecialchars(strip_tags($this->privilege));
        $this->can_comment = htmlspecialchars(strip_tags($this->can_comment));
        $this->num_img = htmlspecialchars(strip_tags($this->num_img));
        $this->img_size = htmlspecialchars(strip_tags($this->img_size));
        $this->num_char_obs = htmlspecialchars(strip_tags($this->num_char_obs));
        $this->num_char_ta = htmlspecialchars(strip_tags($this->num_char_ta));
        $this->user_location_privilege_id = htmlspecialchars(strip_tags($this->user_location_privilege_id));

        // Bind data
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":privilege", $this->privilege);
        $stmt->bindParam(":can_comment", $this->can_comment);
        $stmt->bindParam(":num_img", $this->num_img);
        $stmt->bindParam(":img_size", $this->img_size);
        $stmt->bindParam(":num_char_obs", $this->num_char_obs);
        $stmt->bindParam(":num_char_ta", $this->num_char_ta);
        $stmt->bindParam(":user_location_privilege_id", $this->user_location_privilege_id);


        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE user_location_privilege_id = :user_location_privilege_id";
        $stmt = $this->conn->prepare($query);

        $this->user_location_privilege_id = htmlspecialchars(strip_tags($this->user_location_privilege_id));
        $stmt->bindParam(":user_location_privilege_id", $this->user_location_privilege_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}