<?php
class User {
    // Database connection
    private $conn;
    private $table = "users";
    //`user_id`, `user_fname`, `user_lname`, `user_email`, `user_pin`

    // Properties
    public $user_id;
    public $user_fname;
    public $user_lname;
    public $user_email;
    public $user_pin;

    // Constructor
   public function __construct($db) {
    if ($db) {
        $this->conn = $db;
    } else {
        // Handle database connection error
        die("Database connection failed.");
    }
}
    
    // Get user by $_SESSION["user_id"]
    public function read_user() {
    $query = "SELECT
            users.user_id, users.user_pin, admin_id
    FROM 
        " . $this->table . "
    INNER JOIN admins ON users.user_id = admins.user_id
    WHERE users.user_id = :user_id
    ";
    $stmt = $this->conn->prepare($query);
    $stmt->bindParam(":user_id", $this->user_id); // Bind 1st ? to user_id
    $stmt->execute();

    // Fetch the result as assoc_array
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // One row in API call
    $this->user_id = $row["user_id"]; 
    $this->user_pin = $row["user_pin"]; 
    $this->admin_id = $row["admin_id"]; 
}

    // Get all users
    public function read() {
        $query = "SELECT
            user_id,
            user_fname,
            user_lname,
            user_email
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Get all users By Company Id
    /** 
     * SELECT * FROM `users` INNER JOIN (user_company INNER JOIN companies 
     * ON user_company.company_id = companies.company_id)  
     * ON users.user_id = user_company.user_id WHERE companies.company_id = 1
    */
    public function readUserByCompanyId($company_id) {
        $query = "SELECT
            users.user_id,
            user_fname,
            user_lname,
            user_email
        FROM 
            " . $this->table . 
            " INNER JOIN (user_company INNER JOIN companies 
              ON user_company.company_id = companies.company_id)  
              ON users.user_id = user_company.user_id 
        WHERE 
            companies.company_id = :company_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id); 
        $stmt->execute();
        return $stmt;
    }

    public function getUserByCompanyId($company_id){
        $query = "SELECT *
        FROM 
            " . $this->table . 
            " INNER JOIN
            (user_location_privilege 
            INNER JOIN 
            locations 
            ON user_location_privilege.location_id = locations.location_id) 
            ON users.user_id = user_location_privilege.user_id 
        WHERE 
            locations.company_id = :company_id 
        GROUP BY 
            users.user_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id); 
        $stmt->execute();
        return $stmt;
    }

    //Get user by email
    public function getUserByEmail($user_email) {
        $query = "SELECT
            user_id,
            user_fname,
            user_lname,
            user_email,
            user_pin
        FROM 
            " . $this->table . "
        WHERE
            user_email = :user_email";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_email", $user_email);
        $stmt->execute();

        return $stmt;
    }

    //Add user to company
    public function addUserToCompany($user_id, $company_id, $entry_key) {
        $queryCheck = "SELECT * FROM user_company WHERE user_id = :user_id AND company_id = :company_id";
        $stmtCheck = $this->conn->prepare($queryCheck);
        $stmtCheck->bindParam(":user_id", $user_id);
        $stmtCheck->bindParam(":company_id", $company_id);
        $stmtCheck->execute();

        if ($stmtCheck->rowCount() > 0) {
            // User is already associated with the company
            return false;
        }

        $queryInsert = "INSERT INTO user_company (user_id, company_id, entry_key) VALUES (:user_id, :company_id, :entry_key)";
        $stmtInsert = $this->conn->prepare($queryInsert);
        $stmtInsert->bindParam(":user_id", $user_id);
        $stmtInsert->bindParam(":company_id", $company_id);
        $stmtInsert->bindParam(":entry_key", $entry_key);

        // Execute
        if ($stmtInsert->execute()) {
            return true;
        }

        printf("Error: %s", $stmtInsert->error);
        return false;
    }
    
    // Get user by id
    public function read_single() {
        $query = "SELECT
            user_id,
            user_fname,
            user_lname,
            user_email
        FROM 
            " . $this->table . "
        WHERE
            user_id = :user_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":user_id", $this->user_id); // Bind 1st ? to user_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->user_fname = $row["user_fname"]; 
        $this->user_lname = $row["user_lname"]; 
        $this->user_email = $row["user_email"]; 
    }
    
    // Create a user
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            user_fname = :user_fname,
            user_lname = :user_lname,
            user_email = :user_email,
            user_pin = :user_pin
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_fname = htmlspecialchars(strip_tags($this->user_fname));
        $this->user_lname = htmlspecialchars(strip_tags($this->user_lname));
        $this->user_email = htmlspecialchars(strip_tags($this->user_email));
        $this->user_pin = htmlspecialchars(strip_tags($this->user_pin));

        // Bind data
        $stmt->bindParam(":user_fname", $this->user_fname);
        $stmt->bindParam(":user_lname", $this->user_lname);
        $stmt->bindParam(":user_email", $this->user_email);
        $stmt->bindParam(":user_pin", $this->user_pin);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update user
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            user_fname = :user_fname,
            user_lname = :user_lname,
            user_email = :user_email,
            user_pin = :user_pin
        WHERE
            user_id = :user_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_fname = htmlspecialchars(strip_tags($this->user_fname));
        $this->user_lname = htmlspecialchars(strip_tags($this->user_lname));
        $this->user_email = htmlspecialchars(strip_tags($this->user_email));
        $this->user_pin = htmlspecialchars(strip_tags($this->user_pin));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));

        // Bind data
        $stmt->bindParam(":user_fname", $this->user_fname);
        $stmt->bindParam(":user_lname", $this->user_lname);
        $stmt->bindParam(":user_email", $this->user_email);
        $stmt->bindParam(":user_pin", $this->user_pin);
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE user_id = :user_id";
        $stmt = $this->conn->prepare($query);

        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}