<?php
class RegulationRegCategory {
    // Database connection
    private $conn;
    private $table = "regulations_reg_categories";

    // Properties
    public $regulations_reg_categories_id;
    public $regulation_id;
    public $reg_category_id;
 
    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            regulations_reg_categories_id,
            regulation_id,
            reg_category_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            regulations_reg_categories_id,
            regulation_id,
            reg_category_id
        FROM 
            " . $this->table . "
        WHERE
            regulations_reg_categories_id = :regulations_reg_categories_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":regulations_reg_categories_id", $this->regulations_reg_categories_id);
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->regulations_reg_categories_id = $row["regulations_reg_categories_id"]; 
        $this->regulation_id = $row["regulation_id"]; 
        $this->reg_category_id = $row["reg_category_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            regulation_id = :regulation_id,
            reg_category_id = :reg_category_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->regulation_id = htmlspecialchars(strip_tags($this->regulation_id));
        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));

        // Bind data
        $stmt->bindParam(":regulation_id", $this->regulation_id);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            regulation_id = :regulation_id,
            reg_category_id = :reg_category_id

        WHERE
            regulations_reg_categories_id = :regulations_reg_categories_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->regulation_id = htmlspecialchars(strip_tags($this->regulation_id));
        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));
        $this->regulations_reg_categories_id = htmlspecialchars(strip_tags($this->regulations_reg_categories_id));

        // Bind data
        $stmt->bindParam(":regulation_id", $this->regulation_id);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);
        $stmt->bindParam(":regulations_reg_categories_id", $this->regulations_reg_categories_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE regulations_reg_categories_id = :regulations_reg_categories_id";
        $stmt = $this->conn->prepare($query);

        $this->regulations_reg_categories_id = htmlspecialchars(strip_tags($this->regulations_reg_categories_id));
        $stmt->bindParam(":regulations_reg_categories_id", $this->regulations_reg_categories_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}