<?php
class Regulation {
    // Database connection
    private $conn;
    private $table = "regulations";

    // Properties
    public $regulation_id;
    public $title;
    public $created_at;
    public $version1;
    public $version2;
    public $version3;
    public $reg_category_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            regulation_id,
            title,
            created_at,
            version1,
            version2,
            version3,
            reg_category_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            regulation_id,
            title,
            created_at,
            version1,
            version2,
            version3,
            reg_category_id
        FROM 
            " . $this->table . "
        WHERE
            regulation_id = :regulation_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":regulation_id", $this->regulation_id); // Bind 1st ? to regulation_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->title = $row["title"]; 
        $this->created_at = $row["created_at"]; 
        $this->version1 = $row["version1"];
        $this->version2 = $row["version2"]; 
        $this->version3 = $row["version3"]; 
        $this->reg_category_id = $row["reg_category_id"];  
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            title = :title,
            created_at = CURRENT_TIMESTAMP,
            version1 = :version1,
            version2 = :version2,
            version3 = :version3,
            reg_category_id = :reg_category_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->version1 = htmlspecialchars(strip_tags($this->version1));
        $this->version2 = htmlspecialchars(strip_tags($this->version2));
        $this->version3 = htmlspecialchars(strip_tags($this->version3));
        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":version1", $this->version1);
        $stmt->bindParam(":version2", $this->version2);
        $stmt->bindParam(":version3", $this->version3);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            title = :title,
            created_at = CURRENT_TIMESTAMP,
            version1 = :version1,
            version2 = :version2,
            version3 = :version3,
            reg_category_id = :reg_category_id
        WHERE
            regulation_id = :regulation_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->version1 = htmlspecialchars(strip_tags($this->version1));
        $this->version2 = htmlspecialchars(strip_tags($this->version2));
        $this->version3 = htmlspecialchars(strip_tags($this->version3));
        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));
        $this->regulation_id = htmlspecialchars(strip_tags($this->regulation_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":version1", $this->version1);
        $stmt->bindParam(":version2", $this->version2);
        $stmt->bindParam(":version3", $this->version3);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);
        $stmt->bindParam(":regulation_id", $this->regulation_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE regulation_id = :regulation_id";
        $stmt = $this->conn->prepare($query);

        $this->regulation_id = htmlspecialchars(strip_tags($this->regulation_id));
        $stmt->bindParam(":regulation_id", $this->regulation_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}



