<?php
class Region {
    // Database connection
    private $conn;
    private $table = "regions";

    // Properties
    public $region_id;
    public $region_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            region_id,
            region_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            region_id,
            region_name
        FROM 
            " . $this->table . "
        WHERE
            region_id = :region_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":region_id", $this->region_id); // Bind 1st ? to region_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->region_id = $row["region_id"]; 
        $this->region_name = $row["region_name"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            region_name = :region_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->region_name = htmlspecialchars(strip_tags($this->region_name));

        // Bind data
        $stmt->bindParam(":region_name", $this->region_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            region_name = :region_name
        WHERE
            region_id = :region_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->region_name = htmlspecialchars(strip_tags($this->region_name));
        $this->region_id = htmlspecialchars(strip_tags($this->region_id));

        // Bind data
        $stmt->bindParam(":region_name", $this->region_name);
        $stmt->bindParam(":region_id", $this->region_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE region_id = :region_id";
        $stmt = $this->conn->prepare($query);

        $this->region_id = htmlspecialchars(strip_tags($this->region_id));
        $stmt->bindParam(":region_id", $this->region_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}