<?php
class RegCategory {
    // Database connection
    private $conn;
    private $table = "reg_categories";

    // Properties
    public $reg_category_id;
    public $reg_category_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            reg_category_id,
            reg_category_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            reg_category_id,
            reg_category_name
        FROM 
            " . $this->table . "
        WHERE
            reg_category_id = :reg_category_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id); // Bind 1st ? to reg_category_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->reg_category_id = $row["reg_category_id"]; 
        $this->reg_category_name = $row["reg_category_name"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            reg_category_name = :reg_category_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->reg_category_name = htmlspecialchars(strip_tags($this->reg_category_name));

        // Bind data
        $stmt->bindParam(":reg_category_name", $this->reg_category_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update user
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            reg_category_name = :reg_category_name
        WHERE
            reg_category_id = :reg_category_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->reg_category_name = htmlspecialchars(strip_tags($this->reg_category_name));
        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));

        // Bind data
        $stmt->bindParam(":reg_category_name", $this->reg_category_name);
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE reg_category_id = :reg_category_id";
        $stmt = $this->conn->prepare($query);

        $this->reg_category_id = htmlspecialchars(strip_tags($this->reg_category_id));
        $stmt->bindParam(":reg_category_id", $this->reg_category_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}