<?php
class Provider {
    // Database connection
    private $conn;
    private $table = "providers";

    // Properties
    public $provider_id;
    public $provider_title;
    public $city_id;
    public $provider_inum;
    public $provider_phone;
    public $provider_email;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            provider_id,
            provider_title,
            city_id,
            provider_inum,
            provider_phone,
            provider_email,
            pc_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Get Licences By Provider Id
    public function readLicencesByProviderId($provider_id) {
        $query = "SELECT 
            *
        FROM 
            " . $this->table . "
        INNER JOIN 
            provider_licences 
                ON providers.provider_id = provider_licences.provider_id
        WHERE provider_licences.provider_id = :provider_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":provider_id", $provider_id); 
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            provider_id,
            provider_title,
            city_id,
            provider_inum,
            provider_phone,
            provider_email,
            pc_id
        FROM 
            " . $this->table . "
        WHERE
        provider_id = :provider_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":provider_id", $this->provider_id); 
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->provider_title = $row["provider_title"]; 
        $this->city_id = $row["city_id"]; 
        $this->provider_inum = $row["provider_inum"]; 
        $this->provider_phone = $row["provider_phone"]; 
        $this->provider_email = $row["provider_email"]; 
        $this->pc_id = $row["pc_id"]; 
    }

    //Filter
    public function search($city_id, $pc_id) {
        $query = "SELECT
            p.provider_id,
            p.provider_title,
            p.city_id,
            p.provider_inum,
            p.provider_phone,
            p.provider_email,
            p.pc_id,
            c.city_name,
            prov_cat.pc_name
        FROM 
            providers p
        INNER JOIN
            cities c ON p.city_id = c.city_id
        INNER JOIN 
            provider_categories prov_cat ON p.pc_id = prov_cat.pc_id    
        WHERE 
            (p.city_id = :city_id AND p.pc_id = :pc_id)
            OR (p.city_id = :city_id AND p.pc_id = :pc_id)
            OR (p.city_id = :city_id AND p.pc_id = :pc_id)
            OR (p.city_id = :city_id AND p.pc_id = :pc_id)";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":city_id", $city_id);
        $stmt->bindParam(":pc_id", $pc_id);
        $stmt->execute();
        return $stmt;
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
        provider_title = :provider_title,
        city_id = :city_id,
        provider_inum = :provider_inum,
        provider_phone = :provider_phone,
        provider_email = :provider_email,
        pc_id = :pc_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->provider_title = htmlspecialchars(strip_tags($this->provider_title));
        $this->city_id = htmlspecialchars(strip_tags($this->city_id));
        $this->provider_inum = htmlspecialchars(strip_tags($this->provider_inum));
        $this->provider_phone = htmlspecialchars(strip_tags($this->provider_phone));
        $this->provider_email = htmlspecialchars(strip_tags($this->provider_email));
        $this->pc_id = htmlspecialchars(strip_tags($this->pc_id));

        // Bind data
        $stmt->bindParam(":provider_title", $this->provider_title);
        $stmt->bindParam(":city_id", $this->city_id);
        $stmt->bindParam(":provider_inum", $this->provider_inum);
        $stmt->bindParam(":provider_phone", $this->provider_phone);
        $stmt->bindParam(":provider_email", $this->provider_email);
        $stmt->bindParam(":pc_id", $this->pc_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update comment
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            provider_title = :provider_title,
            city_id = :city_id,
            provider_inum = :provider_inum,
            provider_phone = :provider_phone,
            provider_email = :provider_email,
            pc_id = :pc_id
        WHERE
            provider_id = :provider_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->provider_title = htmlspecialchars(strip_tags($this->provider_title));
        $this->city_id = htmlspecialchars(strip_tags($this->city_id));
        $this->provider_inum = htmlspecialchars(strip_tags($this->provider_inum));
        $this->provider_phone = htmlspecialchars(strip_tags($this->provider_phone));
        $this->provider_email = htmlspecialchars(strip_tags($this->provider_email));
        $this->provider_id = htmlspecialchars(strip_tags($this->provider_id));
        $this->pc_id = htmlspecialchars(strip_tags($this->pc_id));

        // Bind data
        $stmt->bindParam(":provider_title", $this->provider_title);
        $stmt->bindParam(":city_id", $this->city_id);
        $stmt->bindParam(":provider_inum", $this->provider_inum);
        $stmt->bindParam(":provider_phone", $this->provider_phone);
        $stmt->bindParam(":provider_email", $this->provider_email);
        $stmt->bindParam(":provider_id", $this->provider_id);
        $stmt->bindParam(":pc_id", $this->pc_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete comment
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE provider_id = :provider_id";
        $stmt = $this->conn->prepare($query);

        $this->provider_id = htmlspecialchars(strip_tags($this->provider_id));
        $stmt->bindParam(":provider_id", $this->provider_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}