<?php 
class Message 
{
    // Database connection
    private $conn;
    private $table = "messages";

    // Properties
    public $message_id;
    public $message_sender;
    public $message_time;
    public $message_text;
    public $room_id;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all profiles by user id
    public function read($room_id) {
        $query = "SELECT
            message_id,
            message_sender,
            message_time,
            message_text,
            room_id
            
        FROM 
            " . $this->table . "
        WHERE 
           room_id = :room_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":room_id", $room_id); // Bind 1st ? to room_id
        $stmt->execute();
        return $stmt;
    }
}