<?php
class LocationEvent {
    // Database connection
    private $conn;
    private $table = "location_events";

    // Properties
    public $location_events_id;
    public $title;
    public $date;
    public $created;
    public $modified;
    public $status;
    public $location_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function read() {
        $query = "SELECT
            location_events_id,
            title,
            date,
            created,
            modified,
            status,
            location_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            location_events_id,
            title,
            date,
            created,
            modified,
            status,
            location_id
        FROM 
            " . $this->table . "
        WHERE
            location_events_id = :location_events_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":location_events_id", $this->location_events_id); // Bind 1st ? to location_events_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->title = $row["title"]; 
        $this->date = $row["date"]; 
        $this->created = $row["created"];
        $this->modified = $row["modified"]; 
        $this->status = $row["status"]; 
        $this->location_id = $row["location_id"];  
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            title = :title,
            date = :date,
            created = CURRENT_TIMESTAMP,
            modified = CURRENT_TIMESTAMP,
            location_id = :location_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->date = date("Y-m-d", strtotime(htmlspecialchars(strip_tags($this->date))));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":date", $this->date);
        $stmt->bindParam(":location_id", $this->location_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            title = :title,
            date = :date,
            created = CURRENT_TIMESTAMP,
            modified = CURRENT_TIMESTAMP,
            status = :status,
            location_id = :location_id
        WHERE
            location_events_id = :location_events_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->date = date("Y-m-d", strtotime(htmlspecialchars(strip_tags($this->date))));
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->location_events_id = htmlspecialchars(strip_tags($this->location_events_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":date", $this->date);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":location_events_id", $this->location_events_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE location_events_id = :location_events_id";
        $stmt = $this->conn->prepare($query);

        $this->location_events_id = htmlspecialchars(strip_tags($this->location_events_id));
        $stmt->bindParam(":location_events_id", $this->location_events_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}



