<?php
class Language {
    // Database connection
    private $conn;
    private $table = "languages";

    // Properties
    public $language_id;
    public $lang_name;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            language_id,
            lang_name
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            language_id,
            lang_name
        FROM 
            " . $this->table . "
        WHERE
            language_id = :language_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":language_id", $this->language_id); // Bind 1st ? to language_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->language_id = $row["language_id"]; 
        $this->lang_name = $row["lang_name"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            lang_name = :lang_name
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->lang_name = htmlspecialchars(strip_tags($this->lang_name));

        // Bind data
        $stmt->bindParam(":lang_name", $this->lang_name);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            lang_name = :lang_name
        WHERE
            language_id = :language_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->lang_name = htmlspecialchars(strip_tags($this->lang_name));
        $this->language_id = htmlspecialchars(strip_tags($this->language_id));

        // Bind data
        $stmt->bindParam(":lang_name", $this->lang_name);
        $stmt->bindParam(":language_id", $this->language_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE language_id = :language_id";
        $stmt = $this->conn->prepare($query);

        $this->language_id = htmlspecialchars(strip_tags($this->language_id));
        $stmt->bindParam(":language_id", $this->language_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}