<?php
class Header {
    // Database connection
    private $conn;
    private $table = "headers";

    // Properties
    public $head_id;
    public $head_rep_title;
    public $head_comp_label;
    public $head_comp_title;
    public $head_proj_label;
    public $head_proj_title;
    public $head_loc_label;
    public $head_loc_title;
    public $head_logo;
    public $location_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            head_id,
            head_rep_title,
            head_comp_label,
            head_comp_title,
            head_proj_label,
            head_proj_title,
            head_loc_label,
            head_loc_title,
            head_logo,
            location_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            head_id,
            head_rep_title,
            head_comp_label,
            head_comp_title,
            head_proj_label,
            head_proj_title,
            head_loc_label,
            head_loc_title,
            head_logo,
            location_id
        FROM 
            " . $this->table . "
        WHERE
            head_id = :head_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":head_id", $this->head_id); // Bind 1st ? to head_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->head_id = $row["head_id"]; 
        $this->head_rep_title = $row["head_rep_title"]; 
        $this->head_comp_label = $row["head_comp_label"]; 
        $this->head_comp_title = $row["head_comp_title"]; 
        $this->head_proj_label = $row["head_proj_label"]; 
        $this->head_proj_title = $row["head_proj_title"]; 
        $this->head_loc_label = $row["head_loc_label"]; 
        $this->head_loc_title = $row["head_loc_title"]; 
        $this->head_logo = $row["head_logo"];
        $this->location_id = $row["location_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            head_rep_title = :head_rep_title,
            head_comp_label = :head_comp_label,
            head_comp_title = :head_comp_title,
            head_proj_label = :head_proj_label,
            head_proj_title = :head_proj_title,
            head_loc_label = :head_loc_label,
            head_loc_title = :head_loc_title,
            head_logo = :head_logo,
            location_id = :location_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->head_rep_title = htmlspecialchars(strip_tags($this->head_rep_title));
        $this->head_comp_label = htmlspecialchars(strip_tags($this->head_comp_label));
        $this->head_comp_title = htmlspecialchars(strip_tags($this->head_comp_title));
        $this->head_proj_label = htmlspecialchars(strip_tags($this->head_proj_label));
        $this->head_proj_title = htmlspecialchars(strip_tags($this->head_proj_title));
        $this->head_loc_label = htmlspecialchars(strip_tags($this->head_loc_label));
        $this->head_loc_title = htmlspecialchars(strip_tags($this->head_loc_title));
        $this->head_logo = htmlspecialchars(strip_tags($this->head_logo));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));

        // Bind data
        $stmt->bindParam(":head_rep_title", $this->head_rep_title);
        $stmt->bindParam(":head_comp_label", $this->head_comp_label);
        $stmt->bindParam(":head_comp_title", $this->head_comp_title);
        $stmt->bindParam(":head_proj_label", $this->head_proj_label);
        $stmt->bindParam(":head_proj_title", $this->head_proj_title);
        $stmt->bindParam(":head_loc_label", $this->head_loc_label);
        $stmt->bindParam(":head_loc_title", $this->head_loc_title);
        $stmt->bindParam(":head_logo", $this->head_logo);
        $stmt->bindParam(":location_id", $this->location_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            head_rep_title = :head_rep_title,
            head_comp_label = :head_comp_label,
            head_comp_title = :head_comp_title,
            head_proj_label = :head_proj_label,
            head_proj_title = :head_proj_title,
            head_loc_label = :head_loc_label,
            head_loc_title = :head_loc_title,
            head_logo = :head_logo,
            location_id = :location_id
        WHERE
            head_id = :head_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->head_rep_title = htmlspecialchars(strip_tags($this->head_rep_title));
        $this->head_comp_label = htmlspecialchars(strip_tags($this->head_comp_label));
        $this->head_comp_title = htmlspecialchars(strip_tags($this->head_comp_title));
        $this->head_proj_label = htmlspecialchars(strip_tags($this->head_proj_label));
        $this->head_proj_title = htmlspecialchars(strip_tags($this->head_proj_title));
        $this->head_loc_label = htmlspecialchars(strip_tags($this->head_loc_label));
        $this->head_loc_title = htmlspecialchars(strip_tags($this->head_loc_title));
        $this->head_logo = htmlspecialchars(strip_tags($this->head_logo));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->head_id = htmlspecialchars(strip_tags($this->head_id));

        // Bind data
        $stmt->bindParam(":head_rep_title", $this->head_rep_title);
        $stmt->bindParam(":head_comp_label", $this->head_comp_label);
        $stmt->bindParam(":head_comp_title", $this->head_comp_title);
        $stmt->bindParam(":head_proj_label", $this->head_proj_label);
        $stmt->bindParam(":head_proj_title", $this->head_proj_title);
        $stmt->bindParam(":head_loc_label", $this->head_loc_label);
        $stmt->bindParam(":head_loc_title", $this->head_loc_title);
        $stmt->bindParam(":head_logo", $this->head_logo);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":head_id", $this->head_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE head_id = :head_id";
        $stmt = $this->conn->prepare($query);

        $this->head_id = htmlspecialchars(strip_tags($this->head_id));
        $stmt->bindParam(":head_id", $this->head_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}