<?php
class Gallery {
    // Database connection
    private $conn;
    private $table = "gallery";

    // Properties
    public $gallery_id;
    public $file_name;
    public $company_id;
    public $location_id;
    public $user_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all 
    public function read() {
        $query = "SELECT
            gallery_id,
            file_name,
            company_id,
            location_id,
            user_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            gallery_id,
            file_name,
            company_id,
            location_id,
            user_id
        FROM 
            " . $this->table . "
        WHERE
        gallery_id = :gallery_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":gallery_id", $this->gallery_id); // Bind 1st ? to gallery_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->gallery_id = $row["gallery_id"]; 
        $this->file_name = $row["file_name"]; 
        $this->company_id = $row["company_id"]; 
        $this->location_id = $row["location_id"]; 
        $this->user_id = $row["user_id"]; 
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            file_name = :file_name,
            company_id = :company_id,
            location_id = :location_id,
            user_id = :user_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->file_name = htmlspecialchars(strip_tags($this->file_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));

        // Bind data
        $stmt->bindParam(":file_name", $this->file_name);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":user_id", $this->user_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            file_name = :file_name,
            company_id = :company_id,
            location_id = :location_id,
            user_id = :user_id
        WHERE
            gallery_id = :gallery_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->file_name = htmlspecialchars(strip_tags($this->file_name));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->gallery_id = htmlspecialchars(strip_tags($this->gallery_id));

        // Bind data
        $stmt->bindParam(":file_name", $this->file_name);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":gallery_id", $this->gallery_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE gallery_id = :gallery_id";
        $stmt = $this->conn->prepare($query);

        $this->gallery_id = htmlspecialchars(strip_tags($this->gallery_id));
        $stmt->bindParam(":gallery_id", $this->gallery_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}