<?php
class CompanyPlace {
    // Database connection
    private $conn;
    private $table = "company_places";
    

    // Properties
    public $company_place_id;
    public $company_place_name;
    public $company_place_address;
    public $company_google_maps_link;
    public $company_place_city;
    public $company_id;
    public $admin_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // // Get all places
    // public function read() {
    //     $query = "SELECT
    //         company_place_id,
    //         company_place_name,
    //         company_place_address,
    //         company_google_maps_link,
    //         company_place_city,
    //         admin_id,
    //         company_id
    //     FROM 
    //         " . $this->table . 
    //         "";
    //     $stmt = $this->conn->prepare($query);
    //     $stmt->execute();
    //     return $stmt;
    // }

    // Get all places by company_id
    public function read($company_id) {
        $query = "SELECT
            company_place_id,
            company_place_name,
            company_place_address,
            company_google_maps_link,
            company_place_city,
            admin_id,
            company_id
            FROM 
            " . $this->table . "
        WHERE 
            company_id = :company_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_id", $company_id);
        $stmt->execute();
        return $stmt;
    }

    // Get all places by admin_id
    public function readByAdminId($admin_id) {
        $query = "SELECT
            company_place_id,
            company_place_name,
            company_place_address,
            company_google_maps_link,
            company_place_city,
            admin_id,
            company_id
            FROM 
            " . $this->table . "
        WHERE 
            admin_id = :admin_id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_id", $admin_id);
        $stmt->execute();
        return $stmt;
    }
    
    // Get place by id
    public function read_single() {
        $query = "SELECT
            company_place_id,
            company_place_name,
            company_place_address,
            company_google_maps_link,
            company_place_city,
            admin_id,
            company_id
        FROM 
            " . $this->table . "
        WHERE
            company_place_id = :company_place_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_place_id", $this->company_place_id); // Bind 1st ? to company_place_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->company_place_name = $row["company_place_name"]; 
        $this->company_place_address = $row["company_place_address"]; 
        $this->company_google_maps_link = $row["company_google_maps_link"]; 
        $this->company_place_city = $row["company_place_city"]; 
        $this->admin_id = $row["admin_id"]; 
        $this->company_id = $row["company_id"]; 
    }
    
    // Create company place
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            company_place_name = :company_place_name,
            company_place_address = :company_place_address,
            company_google_maps_link = :company_google_maps_link,
            company_place_city = :company_place_city,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);
       
        // Filter data
        $this->company_place_name = htmlspecialchars(strip_tags($this->company_place_name));
        $this->company_place_address = htmlspecialchars(strip_tags($this->company_place_address));
        $this->company_google_maps_link = "https://www.google.com/maps/search/?api=1&query=" . 
                urlencode("$this->company_place_name") . "," . 
                urlencode("$this->company_place_address") . "," . 
                urlencode("$this->company_place_city");
        $this->company_place_city = htmlspecialchars(strip_tags($this->company_place_city));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":company_place_name", $this->company_place_name);
        $stmt->bindParam(":company_place_address", $this->company_place_address);
        $stmt->bindParam(":company_google_maps_link", $this->company_google_maps_link);
        $stmt->bindParam(":company_place_city", $this->company_place_city);
        $stmt->bindParam(":company_id", $this->company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    
    // Update company place
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            company_place_name = :company_place_name,
            company_place_address = :company_place_address,
            company_google_maps_link = :company_google_maps_link,
            company_place_city = :company_place_city
        WHERE
            company_place_id = :company_place_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->company_place_name = htmlspecialchars(strip_tags($this->company_place_name));
        $this->company_place_address = htmlspecialchars(strip_tags($this->company_place_address));
        $this->company_google_maps_link = "https://www.google.com/maps/search/?api=1&query=" . 
                urlencode("$this->company_place_name") . "," . 
                urlencode("$this->company_place_address") . "," . 
                urlencode("$this->company_place_city");
        $this->company_place_city = htmlspecialchars(strip_tags($this->company_place_city));
        // $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        // $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->company_place_id = htmlspecialchars(strip_tags($this->company_place_id));

        // Bind data
        $stmt->bindParam(":company_place_name", $this->company_place_name);
        $stmt->bindParam(":company_place_address", $this->company_place_address);
        $stmt->bindParam(":company_google_maps_link", $this->company_google_maps_link);
        $stmt->bindParam(":company_place_city", $this->company_place_city);
        // $stmt->bindParam(":admin_id", $this->admin_id);
        // $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":company_place_id", $this->company_place_id);


        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete company place
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE company_place_id = :company_place_id";
        $stmt = $this->conn->prepare($query);

        $this->company_place_id = htmlspecialchars(strip_tags($this->company_place_id));
        $stmt->bindParam(":company_place_id", $this->company_place_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}