<?php
class CompanyEvent {
    // Database connection
    private $conn;
    private $table = "company_events";

    // Properties
    public $company_events_id;
    public $title;
    public $date;
    public $created;
    public $modified;
    public $status;
    public $company_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all
    public function getLastEvent() {
        $query = "SELECT
            company_events_id,
            title,
            date,
            created,
            modified,
            status,
            company_id
        FROM 
            " . $this->table . "
        ORDER BY created DESC LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Get all
    public function read() {
        $query = "SELECT
            company_events_id,
            title,
            date,
            created,
            modified,
            status,
            company_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            company_events_id,
            title,
            date,
            created,
            modified,
            status,
            company_id
        FROM 
            " . $this->table . "
        WHERE
            company_events_id = :company_events_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":company_events_id", $this->company_events_id); // Bind 1st ? to company_events_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->title = $row["title"]; 
        $this->date = $row["date"]; 
        $this->created = $row["created"];
        $this->modified = $row["modified"]; 
        $this->status = $row["status"]; 
        $this->company_id = $row["company_id"];  
    }
    
    // Create
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            title = :title,
            date = :date,
            created = CURRENT_TIMESTAMP,
            modified = CURRENT_TIMESTAMP,
            company_id = :company_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->date = date("Y-m-d", strtotime(htmlspecialchars(strip_tags($this->date))));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":date", $this->date);
        $stmt->bindParam(":company_id", $this->company_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            title = :title,
            date = :date,
            created = CURRENT_TIMESTAMP,
            modified = CURRENT_TIMESTAMP,
            status = :status,
            company_id = :company_id
        WHERE
            company_events_id = :company_events_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->date = date("Y-m-d", strtotime(htmlspecialchars(strip_tags($this->date))));
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->company_id = htmlspecialchars(strip_tags($this->company_id));
        $this->company_events_id = htmlspecialchars(strip_tags($this->company_events_id));

        // Bind data
        $stmt->bindParam(":title", $this->title);
        $stmt->bindParam(":date", $this->date);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":company_id", $this->company_id);
        $stmt->bindParam(":company_events_id", $this->company_events_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE company_events_id = :company_events_id";
        $stmt = $this->conn->prepare($query);

        $this->company_events_id = htmlspecialchars(strip_tags($this->company_events_id));
        $stmt->bindParam(":company_events_id", $this->company_events_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}



