<?php
class Category {
    // Database connection
    private $conn;
    private $table = "categories";

    // Properties
    public $cat_id;
    public $cat_name;
    public $cat_char;
    public $cat_color;
    public $location_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all categories
    public function read() {
        $query = "SELECT
            cat_id,
            cat_name,
            cat_char,
            cat_color,
            location_id
        FROM 
            " . $this->table . "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Get all categories by Location id
    public function getCategoriesByLocationId() {
        $query = "SELECT
            cat_id,
            cat_name,
            cat_char,
            cat_color,
            location_id
        FROM 
            " . $this->table . "
        WHERE 
            location_id = :location_id    
            ";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":location_id", $this->location_id); // Bind 1st ? to cat_id
        $stmt->execute();
        
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        // One row in API call
        $this->cat_id = $row["cat_id"]; 
        $this->cat_name = $row["cat_name"]; 
        $this->cat_char = $row["cat_char"];
        $this->cat_color = $row["cat_color"];
    }
    
    // Get by id
    public function read_single() {
        $query = "SELECT
            cat_id,
            cat_name,
            cat_char,
            cat_color,
            location_id
        FROM 
            " . $this->table . "
       WHERE 
            cat_id = :cat_id    
       ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":cat_id", $this->cat_id); // Bind 1st ? to cat_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->cat_id = $row["cat_id"]; 
        $this->cat_name = $row["cat_name"]; 
        $this->cat_char = $row["cat_char"];
        $this->cat_color = $row["cat_color"];
    }
    
    // Create a user
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            cat_name = :cat_name,
            cat_char = :cat_char,
            cat_color = :cat_color,
            location_id = :location_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->cat_name = htmlspecialchars(strip_tags($this->cat_name));
        $this->cat_char = htmlspecialchars(strip_tags($this->cat_char));
        $this->cat_color = htmlspecialchars(strip_tags($this->cat_color));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));

        // Bind data
        $stmt->bindParam(":cat_name", $this->cat_name);
        $stmt->bindParam(":cat_char", $this->cat_char);
        $stmt->bindParam(":cat_color", $this->cat_color);
        $stmt->bindParam(":location_id", $this->location_id);


        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update user
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            cat_name = :cat_name,
            cat_char = :cat_char,
            cat_color = :cat_color,
            location_id = :location_id
        WHERE
            cat_id = :cat_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->cat_name = htmlspecialchars(strip_tags($this->cat_name));
        $this->cat_char = htmlspecialchars(strip_tags($this->cat_char));
        $this->cat_color = htmlspecialchars(strip_tags($this->cat_color));
        $this->location_id = htmlspecialchars(strip_tags($this->location_id));
        $this->cat_id = htmlspecialchars(strip_tags($this->cat_id));

        // Bind data
        $stmt->bindParam(":cat_name", $this->cat_name);
        $stmt->bindParam(":cat_char", $this->cat_char);
        $stmt->bindParam(":cat_color", $this->cat_color);
        $stmt->bindParam(":location_id", $this->location_id);
        $stmt->bindParam(":cat_id", $this->cat_id);
        

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE cat_id = :cat_id";
        $stmt = $this->conn->prepare($query);

        $this->cat_id = htmlspecialchars(strip_tags($this->cat_id));
        $stmt->bindParam(":cat_id", $this->cat_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}