<?php
class Area {
    // Database connection
    private $conn;
    private $table = "areas";

    // Properties
    public $area_id;
    public $area_title;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all areas
    public function read() {
        $query = "SELECT
            area_id,
            area_title
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get area by id
    public function read_single() {
        $query = "SELECT
            area_id,
            area_title
        FROM 
            " . $this->table . "
        WHERE
            area_id = :area_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":area_id", $this->area_id); // Bind 1st ? to area_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->area_id = $row["area_id"]; 
        $this->area_title = $row["area_title"]; 
    }
    
    // Create a area
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            area_title = :area_title
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->area_title = htmlspecialchars(strip_tags($this->area_title));

        // Bind data
        $stmt->bindParam(":area_title", $this->area_title);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update user
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            area_title = :area_title
        WHERE
            area_id = :area_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->area_title = htmlspecialchars(strip_tags($this->area_title));
        $this->area_id = htmlspecialchars(strip_tags($this->area_id));

        // Bind data
        $stmt->bindParam(":area_title", $this->area_title);
        $stmt->bindParam(":area_id", $this->area_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete a user
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE area_id = :area_id";
        $stmt = $this->conn->prepare($query);

        $this->area_id = htmlspecialchars(strip_tags($this->area_id));
        $stmt->bindParam(":area_id", $this->area_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}