<?php
class AdminPlace {
    // Database connection
    private $conn;
    private $table = "admin_places";
    

    // Properties
    public $admin_place_id;
    public $admin_place_name;
    public $admin_place_address;
    public $admin_google_maps_link;
    public $admin_place_city;
    public $admin_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all places
//     SELECT * FROM admin_places 
    // INNER JOIN (admins INNER JOIN company_admin ON admins.admin_id = company_admin.admin_id) ON admin_places.admin_id = admins.admin_id
    // WHERE company_admin.company_id = 1
// ;
    public function read($admin_id) {
        $query = "SELECT
            admin_place_id,
            admin_place_name,
            admin_place_address,
            admin_google_maps_link,
            admin_place_city
        FROM 
            " . $this->table . 
            " INNER JOIN (admins INNER JOIN company_admin ON admins.admin_id = company_admin.admin_id) ON admin_places.admin_id = admins.admin_id
        WHERE
            admin_places.admin_id = :admin_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_id", $admin_id); // Bind 1st ? to address_book_id
        $stmt->execute();
        return $stmt;
    }

    // public function read($company_id) {
    //     $query = "SELECT
    //         address_book_id,
    //         ab_name,
    //         ab_email
    //     FROM 
    //         " . $this->table . 
    //         " INNER JOIN ((users INNER JOIN (user_company INNER JOIN companies ON user_company.company_id = companies.company_id) ON users.user_id = user_company.user_id) INNER JOIN admins ON users.user_id = admins.user_id) ON address_book.user_id = users.user_id
    //     WHERE 
    //         companies.company_id = :company_id";
    //     $stmt = $this->conn->prepare($query);
    //     $stmt->bindParam(":company_id", $company_id); // Bind 1st ? to address_book_id
    //     $stmt->execute();
    //     return $stmt;
    // }
    
    // Get place by id
    public function read_single() {
        $query = "SELECT
            admin_place_id,
            admin_place_name,
            admin_place_address,
            admin_google_maps_link,
            admin_place_city,
            admin_id
        FROM 
            " . $this->table . "
        WHERE
            admin_place_id = :admin_place_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_place_id", $this->admin_place_id); // Bind 1st ? to admin_place_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->admin_place_name = $row["admin_place_name"]; 
        $this->admin_place_address = $row["admin_place_address"]; 
        $this->admin_google_maps_link = $row["admin_google_maps_link"]; 
        $this->admin_place_city = $row["admin_place_city"]; 
        $this->admin_id = $row["admin_id"]; 
    }
    
    // Create admin place
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            admin_place_name = :admin_place_name,
            admin_place_address = :admin_place_address,
            admin_google_maps_link = :admin_google_maps_link,
            admin_place_city = :admin_place_city,
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);
       
        // Filter data
        $this->admin_place_name = htmlspecialchars(strip_tags($this->admin_place_name));
        $this->admin_place_address = htmlspecialchars(strip_tags($this->admin_place_address));
        $this->admin_google_maps_link = "https://www.google.com/maps/search/?api=1&query=" . 
                urlencode("$this->admin_place_name") . "," . 
                urlencode("$this->admin_place_address") . "," . 
                urlencode("$this->admin_place_city");
        $this->admin_place_city = htmlspecialchars(strip_tags($this->admin_place_city));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));

        // Bind data
        $stmt->bindParam(":admin_place_name", $this->admin_place_name);
        $stmt->bindParam(":admin_place_address", $this->admin_place_address);
        $stmt->bindParam(":admin_google_maps_link", $this->admin_google_maps_link);
        $stmt->bindParam(":admin_place_city", $this->admin_place_city);
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update admin note
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            admin_place_name = :admin_place_name,
            admin_place_address = :admin_place_address,
            admin_google_maps_link = :admin_google_maps_link,
            admin_place_city = :admin_place_city,
            admin_id = :admin_id
        WHERE
            admin_place_id = :admin_place_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->admin_place_name = htmlspecialchars(strip_tags($this->admin_place_name));
        $this->admin_place_address = htmlspecialchars(strip_tags($this->admin_place_address));
        $this->admin_google_maps_link = "https://www.google.com/maps/search/?api=1&query=" . 
                urlencode("$this->admin_place_name") . "," . 
                urlencode("$this->admin_place_address") . "," . 
                urlencode("$this->admin_place_city");
        $this->admin_place_city = htmlspecialchars(strip_tags($this->admin_place_city));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        $this->admin_place_id = htmlspecialchars(strip_tags($this->admin_place_id));

        // Bind data
        $stmt->bindParam(":admin_place_name", $this->admin_place_name);
        $stmt->bindParam(":admin_place_address", $this->admin_place_address);
        $stmt->bindParam(":admin_google_maps_link", $this->admin_google_maps_link);
        $stmt->bindParam(":admin_place_city", $this->admin_place_city);
        $stmt->bindParam(":admin_id", $this->admin_id);
        $stmt->bindParam(":admin_place_id", $this->admin_place_id);


        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    
    // Delete admin place
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE admin_place_id = :admin_place_id";
        $stmt = $this->conn->prepare($query);

        $this->admin_place_id = htmlspecialchars(strip_tags($this->admin_place_id));
        $stmt->bindParam(":admin_place_id", $this->admin_place_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}