<?php
class Admin {
    // Database connection
    private $conn;
    private $table = "admins";

    // Properties
    public $admin_id;
    public $user_id;
    public $admin_role;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all admins
    public function read() {
        $query = "SELECT
            admin_id,
            user_id,
            admin_role
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get admin by id
    public function read_single() {
        $query = "SELECT
            admin_id,
            user_id,
            admin_role
        FROM 
            " . $this->table . "
        WHERE
            admin_id = :admin_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":admin_id", $this->admin_id); // Bind 1st ? to admin_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->user_id = $row["user_id"]; 
        $this->admin_role = $row["admin_role"]; 
    }
    
    // Create admin
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            user_id = :user_id,
            admin_role = :admin_role
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->admin_role = htmlspecialchars(strip_tags($this->admin_role));

        // Bind data
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":admin_role", $this->admin_role);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update admin
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            user_id = :user_id,
            admin_role = :admin_role
        WHERE
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->admin_role = htmlspecialchars(strip_tags($this->admin_role));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));

        // Bind data
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":admin_role", $this->admin_role);
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }

    // Update active/idle
    public function updateStatus() {
        $query = "UPDATE " . $this->table . "
        SET
            active = :active,
            idle = :idle
        WHERE
            admin_id = :admin_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->active = htmlspecialchars(strip_tags($this->active));
        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        $this->idle = htmlspecialchars(strip_tags($this->idle));

        // Bind data
        $stmt->bindParam(":active", $this->active);
        $stmt->bindParam(":admin_id", $this->admin_id);
        $stmt->bindParam(":idle", $this->idle);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete admin
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE admin_id = :admin_id";
        $stmt = $this->conn->prepare($query);

        $this->admin_id = htmlspecialchars(strip_tags($this->admin_id));
        $stmt->bindParam(":admin_id", $this->admin_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}