<?php
class Activity {
    // Database connection
    private $conn;
    private $table = "activities";

    // Properties
    public $act_id;
    public $act_title;
    public $area_id;

    // Constructor
    public function __construct($db) {
        $this->conn = $db;
    }

    // Get all activities
    public function read() {
        $query = "SELECT
            act_id,
            act_title,
            area_id
        FROM 
            " . $this->table . 
            "";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }
    
    // Get activity by id
    public function read_single() {
        $query = "SELECT
            act_id,
            act_title,
            area_id
        FROM 
            " . $this->table . "
        WHERE
            act_id = :act_id
        ";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":act_id", $this->act_id); // Bind 1st ? to act_id
        $stmt->execute();

        // Fetch the result as assoc_array
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
        // One row in API call
        $this->act_title = $row["act_title"]; 
        $this->area_id = $row["area_id"]; 
    }
    
    // Create activity
    public function create() {
        $query = "INSERT INTO " . $this->table . "
        SET
            act_title = :act_title,
            area_id = :area_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->act_title = htmlspecialchars(strip_tags($this->act_title));
        $this->area_id = htmlspecialchars(strip_tags($this->area_id));

        // Bind data
        $stmt->bindParam(":act_title", $this->act_title);
        $stmt->bindParam(":area_id", $this->area_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Update activity
    public function update() {
        $query = "UPDATE " . $this->table . "
        SET
            act_title = :act_title,
            area_id = :area_id
        WHERE
            act_id = :act_id
        ";

        $stmt = $this->conn->prepare($query);

        // Filter data
        $this->act_title = htmlspecialchars(strip_tags($this->act_title));
        $this->area_id = htmlspecialchars(strip_tags($this->area_id));
        $this->act_id = htmlspecialchars(strip_tags($this->act_id));

        // Bind data
        $stmt->bindParam(":act_title", $this->act_title);
        $stmt->bindParam(":area_id", $this->area_id);
        $stmt->bindParam(":act_id", $this->act_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
    
    // Delete activity
    public function delete() {
        $query = "DELETE FROM " . $this->table . " WHERE act_id = :act_id";
        $stmt = $this->conn->prepare($query);

        $this->act_id = htmlspecialchars(strip_tags($this->act_id));
        $stmt->bindParam(":act_id", $this->act_id);

        // Execute
        if ($stmt->execute()) {
            return true;
        }

        printf("Error: %s", $stmt->error);
        return false;
    }
}