<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/User.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

$_SESSION["user_id"] = 1;

if(isset($_SESSION["user_id"])) {
    $user->user_id = $_SESSION["user_id"];
} 

// Store read method result in variable 
$user->read_user();

// User array
$user_arr = array(
    "user_id" => $user->user_id,
    "user_pin" => $user->user_pin,
    "admin_id" => $user->admin_id
);

// Check authentication
if (!check_auth()) {
    // Convert result to JSON
    echo json_encode($user_arr);
} else {
    echo json_encode(
        array("message" => "Not authorized to read this user.")
    );
}
?>
