<?php 
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, DELETE, PUT, PATCH, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Access-Control-Allow-Origin');
header('Access-Control-Max-Age: 1728000');

header('Content-Type: application/JSON');

 
include_once "../../config/Database.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";
include_once "../../models/User.php";



// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

// Store read method result in variable & count rows
$result = $user->read();
$num = $result->rowCount();

if (check_auth()) {
    if ($num > 0) {
        // User array
        $user_arr = array();
        $user_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $user = array(
                'user_id' => $user_id,
                'user_fname' => $user_fname,
                'user_lname' => $user_lname,
                'user_email' => $user_email        
            );

            // Push to "Data"
            array_push($user_arr["data"], $user);
        }
        // Convert result to JSON
        echo json_encode($user_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No users found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read users"
        )
    );
}





