<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../models/User.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$user->user_id = $data->user_id;

// Create a user
if (check_auth()) {
    if ($user->delete()) {
        echo json_encode(
            array("message" => "User deleted")
        );
    } else {
        echo json_encode(
            array("message" => "User not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete this user"
        )
    );
}