<?php 
if (!isset($_SESSION["admin"])) {
    header("Location: https://www.google.com");
}

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../models/User.php";



// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$user = new User($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$user->user_fname = $data->user_fname;
$user->user_lname = $data->user_lname;
$user->user_email = $data->user_email;
$user->user_pin = $data->user_pin;

// Create a user
if (isset($_SESSION["admin"])) {
    if ($user->create()) {
        echo json_encode(
            array("message" => "User created")
        );
    } else {
        echo json_encode(
            array("message" => "User not created")
        );
    }
}