<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Access-Control-Allow-Origin');
header('Content-Type: application/json');

include_once "../../config/Database.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";
include_once "../../models/User.php";

$database = new Database();
$db = $database->connect();

$user = new User($db);

$data = json_decode(file_get_contents("php://input"));
$user_email = $data->user_email;
$company_id = $data->company_id;
$entry_key = $data->entry_key;

$result = $user->getUserByEmail($user_email);

if(check_auth()){
    if ($result->rowCount() > 0) {
        $row = $result->fetch(PDO::FETCH_ASSOC);
        $user_id = $row['user_id'];

        $resultCompany = $user->getUserByCompanyId($company_id);

        $user_exists = false;

        while ($rowCompany = $resultCompany->fetch(PDO::FETCH_ASSOC)) {
            if ($rowCompany['user_id'] == $user_id) {
                $user_exists = true;
                break;
            }
        }

        if ($user_exists) {
            echo json_encode(
                array(
                    "message" => "User is already associated with the company"
                )
            );
        } else {
            $user->addUserToCompany($user_id, $company_id, $entry_key);
            echo json_encode(
                array(
                    "message" => "User added to the company successfully"
                )
            );
        }
    } else {
        echo json_encode(
            array(
                "message" => "User not found with the provided email"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to add user to company"
        )
    );
}

?>
