<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserNote.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$userNote = new UserNote($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userNote->note_id = $data->note_id;
$userNote->content = $data->content;
$userNote->user_id = $data->user_id;

if(check_auth()){
    if ($userNote->update()) {
        echo json_encode(array("message" => "user note updated"));
    } else {
        echo json_encode(array("message" => "user note not updated"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update user note."
        )
    );
}
