<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserNote.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userNote object
$userNote = new UserNote($db);
$userNote->note_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$userNote->read_single();


// userNote array
$userNote_arr = array(
    "note_id" => $userNote->note_id,
    "content" => $userNote->content,
    "created_at" => $userNote->created_at,
    "user_id" => $userNote->user_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($userNote_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user note."
        )
    );
}
