<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../models/UserNote.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$userNote = new UserNote($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userNote->note_id = $data->note_id;

if(check_auth()){
    // Create user note
    if ($userNote->delete()) {
        echo json_encode(
            array("message" => "user note deleted")
        );
    } else {
        echo json_encode(
            array("message" => "user note not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete user note."
        )
    );
}