<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserLocationPrivilege.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLocPriv object
$userLocPriv = new UserLocationPrivilege($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$userLocPriv->user_id = $data->user_id;
$userLocPriv->location_id = $data->location_id;
$userLocPriv->privilege = $data->privilege;
$userLocPriv->can_comment = $data->can_comment;
$userLocPriv->num_img = $data->num_img;
$userLocPriv->img_size = $data->img_size;
$userLocPriv->num_char_obs = $data->num_char_obs;
$userLocPriv->num_char_ta = $data->num_char_ta;
$userLocPriv->user_location_privilege_id = $data->user_location_privilege_id;

if(check_auth()){
    // Create userLocPriv
    if ($userLocPriv->update()) {
        echo json_encode(
            array("message" => "userLocPriv updated")
        );
    } else {
        echo json_encode(
            array("message" => "userLocPriv not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update users."
        )
    );
}