<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserLocationPrivilege.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLocPriv object
$userLocPriv = new UserLocationPrivilege($db);
$userLocPriv->user_location_privilege_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$userLocPriv->read_single();

// userLocPriv array
$userLocPriv_arr = array(
    "user_location_privilege_id" => $userLocPriv->user_location_privilege_id,
    "user_id" => $userLocPriv->user_id,
    "location_id" => $userLocPriv->location_id,
    "privilege" => $userLocPriv->privilege,
    "can_comment" => $userLocPriv->can_comment,
    "num_img" => $userLocPriv->num_img,
    "img_size" => $userLocPriv->img_size,
    "num_char_obs" => $userLocPriv->num_char_obs,
    "num_char_ta" => $userLocPriv->num_char_ta
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($userLocPriv_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user."
        )
    );
}