<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserLocationPrivilege.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLocPriv object
$userLocPriv = new UserLocationPrivilege($db);

// Store read method result in variable & count rows
$result = $userLocPriv->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // userLocPriv array
        $userLocPriv_arr = array();
        $userLocPriv_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each userLocPriv will look like this
            $userLocPriv = array(
                'user_location_privilege_id,' => $user_location_privilege_id,
                'user_id' => $user_id,
                'location_id' => $location_id,
                'privilege' => $privilege,
                'can_comment' => $can_comment,
                'num_img' => $num_img,
                'img_size' => $img_size,
                'num_char_obs' => $num_char_obs,
                'num_char_ta' => $num_char_ta

            );

            // Push to "Data"
            array_push($userLocPriv_arr["data"], $userLocPriv);
        }
        // Convert result to JSON
        echo json_encode($userLocPriv_arr);
    } else {
        // No userLocPrivs returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No userLocPriv found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read users."
        )
    );
}






