<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserLanguage.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLanguage object
$userLanguage = new UserLanguage($db);
$userLanguage->user_location_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$userLanguage->read_single();


// userLanguage array
$userLanguage_arr = array(
    "user_location_id" => $userLanguage->user_location_id,
    "user_id" => $userLanguage->user_id,
    "language_id" => $userLanguage->language_id
    
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($userLanguage_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user language."
        )
    );
}