<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserLanguage.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userLanguage object
$userLanguage = new UserLanguage($db);

// Store read method result in variable & count rows
$result = $userLanguage->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // userLanguage array
        $userLanguage_arr = array();
        $userLanguage_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each userLanguage will look like this
            $userLanguage = array(
                'user_location_id' => $user_location_id, 
                'user_id' => $user_id,
                'language_id' => $language_id     
            );

            // Push to "Data"
            array_push($userLanguage_arr["data"], $userLanguage);
        }
        // Convert result to JSON
        echo json_encode($userLanguage_arr);
    } else {
        // No user Language returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No user Language found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user languages."
        )
    );
}




