<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserDriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$user_dl = new UserDriversLicence($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$user_dl->us_drivers_licence_id = $data->us_drivers_licence_id;

if(check_auth()){
    // Create
    if ($user_dl->delete()) {
        echo json_encode(
            array("message" => "user language deleted")
        );
    } else {
        echo json_encode(
            array("message" => "user language not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete drivers licence."
        )
    );
}