<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserDriversLicence.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init object
$user_dl = new UserDriversLicence($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$user_dl->drivers_licence_id = $data->drivers_licence_id;
$user_dl->user_id = $data->user_id;

if(check_auth()){
    // Create
    if ($user_dl->create()) {
        echo json_encode(
            array("message" => "user drivers_licence created")
        );
    } else {
        echo json_encode(
            array("message" => "user drivers_licence not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create user drivers licence."
        )
    );
}