<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/UserCompany.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userCompany object
$userCompany = new UserCompany($db);
$userCompany->user_company_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$userCompany->read_single();


// userCompany array
$userCompany_arr = array(
    "user_company_id" => $userCompany->user_company_id,
    "user_id" => $userCompany->user_id,
    "company_id" => $userCompany->company_id,
    "entry_key" => $userCompany->entry_key,
    "active" => $userCompany->active
    
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($userCompany_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read user."
        )
    );
}