<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/UserCompany.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init userCompany object
$userCompany = new UserCompany($db);

// Store read method result in variable & count rows
$result = $userCompany->read();
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // userCompany array
        $userCompany_arr = array();
        $userCompany_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each userCompany will look like this
            $userCompany = array(
                'user_company_id' => $user_company_id, 
                'user_id' => $user_id,
                'company_id' => $company_id,
                'entry_key' => $entry_key,
                'active' => $active
            );

            // Push to "Data"
            array_push($userCompany_arr["data"], $userCompany);
        }
        // Convert result to JSON
        echo json_encode($userCompany_arr);
    } else {
        // No user company returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No user company found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read users."
        )
    );
}




