<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Regulation.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init object
$regulation = new Regulation($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$regulation->regulation_id = $data->regulation_id;
$regulation->title = $data->title;
$regulation->version1 = $data->version1;
$regulation->version2 = $data->version2;
$regulation->version3 = $data->version3;
$regulation->reg_category_id = $data->reg_category_id;

if(check_auth()){
    // Create
    if ($regulation->update()) {
        echo json_encode(
            array("message" => "regulation updated")
        );
    } else {
        echo json_encode(
            array("message" => "regulation not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update regulation."
        )
    );
}