<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Regulation.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regulation object
$regulation = new Regulation($db);
$regulation->regulation_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$regulation->read_single();

// regulation array
$regulation_arr = array(
    "regulation_id" => $regulation->regulation_id,
    "title" => $regulation->title,
    "created_at" => $regulation->created_at,
    "version1" => $regulation->version1,
    "version2" => $regulation->version2,
    "version3" => $regulation->version3,
    "reg_category_id" => $regulation->reg_category_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($regulation_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regulation."
        )
    );
}