<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Regulation.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regulation object
$regulation = new Regulation($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$regulation->regulation_id = $data->regulation_id;

if(check_auth()){
    // Create
    if ($regulation->delete()) {
        echo json_encode(
            array("message" => "regulation deleted")
        );
    } else {
        echo json_encode(
            array("message" => "regulation not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete regulation."
        )
    );
}