<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Region.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$region = new Region($db);
$region->region_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$region->read_single();

// region array
$region_arr = array(
    "region_id" => $region->region_id,
    "region_name" => $region->region_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($region_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read region."
        )
    );
}