<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Region.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init region object
$region = new Region($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$region->region_id = $data->region_id;

if(check_auth()){
    // Create a region
    if ($region->delete()) {
        echo json_encode(
            array("message" => "region deleted")
        );
    } else {
        echo json_encode(
            array("message" => "region not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete region."
        )
    );
}