<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/RegCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$regCategory = new RegCategory($db);
$regCategory->reg_category_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$regCategory->read_single();

// regCategory array
$regCategory_arr = array(
    "reg_category_id" => $regCategory->reg_category_id,
    "reg_category_name" => $regCategory->reg_category_name
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($regCategory_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read regulation category."
        )
    );
}