<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/RegCategory.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init regCategory object
$regCategory = new RegCategory($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$regCategory->reg_category_id = $data->reg_category_id;

if(check_auth()){
    // Create a regCategory
    if ($regCategory->delete()) {
        echo json_encode(
            array("message" => "regCategory deleted")
        );
    } else {
        echo json_encode(
            array("message" => "regCategory not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete regulation category."
        )
    );
}