<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Qualification.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init qualification object
$qualification = new Qualification($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$qualification->qualification_id = $data->qualification_id;
$qualification->qual_name = $data->qual_name;

if(check_auth()){
    // Create qualification
    if ($qualification->update()) {
        echo json_encode(
            array("message" => "qualification updated")
        );
    } else {
        echo json_encode(
            array("message" => "qualification not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update qualification."
        )
    );
}