<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Qualification.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init qualification object
$qualification = new Qualification($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$qualification->qual_name = $data->qual_name;

if(check_auth()){
    // Create qualification
    if ($qualification->create()) {
        echo json_encode(
            array("message" => "qualification created")
        );
    } else {
        echo json_encode(
            array("message" => "qualification not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create qualification."
        )
    );
}