<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Provider.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init provider object
$provider = new Provider($db);

$city_id = isset($_GET['city_id']) ? $_GET['city_id'] : null;
$pc_id = isset($_GET['pc_id']) ? $_GET['pc_id'] : null;

$result = $provider->search($city_id, $pc_id);
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // provider array
        $provider_arr = array();
        $provider_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each provider will look like this
            $provider = array(
                'provider_id' => $provider_id,
                'provider_title' => $provider_title,
                'provider_inum' => $provider_inum,
                'provider_phone' => $provider_phone,
                'provider_email' => $provider_email,
                'city_id' => $city_id, 
                'city_name' => $city_name,
                'pc_id' => $pc_id,
                'pc_name' => $pc_name
            );

            // Push to "Data"
            array_push($provider_arr["data"], $provider);
        }

        // Convert result to JSON
        echo json_encode($provider_arr);
    } else {
        // No providers returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No providers found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to search for provider."
        )
    );
}
?>
