<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Provider.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init provider object
$provider = new Provider($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$provider->provider_id = $data->provider_id;

if(check_auth()){
    // Create a provider
    if ($provider->delete()) {
        echo json_encode(
            array("message" => "provider deleted")
        );
    } else {
        echo json_encode(
            array("message" => "provider not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete provider."
        )
    );
}