<?php 

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Provider.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init provider object
$provider = new Provider($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$provider->provider_title = $data->provider_title;
$provider->city_id = $data->city_id;
$provider->provider_inum = $data->provider_inum;
$provider->provider_phone = $data->provider_phone;
$provider->provider_email = $data->provider_email;
$provider->pc_id = $data->pc_id;

if(check_auth()){
    // Create provider
    if ($provider->create()) {
        echo json_encode(
            array("message" => "provider created")
        );
    } else {
        echo json_encode(
            array("message" => "provider not created")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create provider."
        )
    );
}