<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/ProviderLicence.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init providerLicence object
$providerLicence = new ProviderLicence($db);

// Store read method result in variable & count rows
$result = $providerLicence->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // providerLicence array
        $providerLicence_arr = array();
        $providerLicence_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each providerLicence will look like this
            $providerLicence = array(
                'pl_id' => $pl_id,
                'pl_number' => $pl_number,
                'pl_date' => $pl_date,
                'provider_id' => $provider_id
            );
            // Push to "Data"
            array_push($providerLicence_arr["data"], $providerLicence);
        }
        // Convert result to JSON
        echo json_encode($providerLicence_arr);
    } else {
        // No providerLicences returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No providerLicences found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read provider licences."
        )
    );
}




