<?php 
header('Access-Control-Allow-Origin: *');
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/ProviderCategory.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init user object
$providerCategory = new ProviderCategory($db);

// Store read method result in variable & count rows
$result = $providerCategory->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // User array
        $providerCategory_arr = array();
        $providerCategory_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each user will look like this
            $providerCategory = array(
                'pc_id' => $pc_id,
                'pc_name' => $pc_name
            );

            // Push to "Data"
            array_push($providerCategory_arr["data"], $providerCategory);
        }
        // Convert result to JSON
        echo json_encode($providerCategory_arr);
    } else {
        // No users returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No Provider Category found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read provider categories."
        )
    );
}




